package org.amse.mm.myTest;

import junit.framework.TestCase;
import java.io.*;

import org.amse.mm.io.*;
import org.amse.mm.myVirtualBilliards.model.impl.*;

public class IOTest extends TestCase {

	public void test1(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test1.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load test1");
		}
		assertEquals(table.balls().size(), 2);		
	}
	
	public void test2(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test2.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load test2");
		}
		assertEquals(table.balls().size(), 1);		
	}
	
	public void test3(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test3.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load test3");
		}
		assertEquals(table.balls().size(), 1);		
	}
	
	public void test4(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test4.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load test4");
		}
		assertEquals(table.balls().size(), 0);		
	}
	
	public void test5(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test5.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load test5");
		}
		assertEquals(table.balls().size(), 1);		
	}
	
	public void test6(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/notExistFile.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load test6");
		}
		assertEquals(table.balls().size(), 0);		
	}
	
	public void test7(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test6.txt");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load test7");
		}
		assertEquals(table.balls().size(), 1);		
	}
	
	public void test8(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test1.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		
		try{
			OutputStream stream = new FileOutputStream("IOTest/outputTest1.xml");
			XMLWriter writer = new XMLWriter();
			writer.write(table, stream, true);
		}catch(Exception ex){
			System.out.println("can't load");
		}
		table.clearTable();
		
		try{
			InputStream stream = new FileInputStream("IOTest/outputTest1.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		assertEquals(table.balls().size(), 2);
	}
	
	public void test9(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test2.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		
		try{
			OutputStream stream = new FileOutputStream("IOTest/outputTest2.xml");
			XMLWriter writer = new XMLWriter();
			writer.write(table, stream, true);
		}catch(Exception ex){
			System.out.println("can't load");
		}
		table.clearTable();
		
		try{
			InputStream stream = new FileInputStream("IOTest/outputTest2.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		assertEquals(table.balls().size(), 1);
	}
	
	public void test10(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test3.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		
		try{
			OutputStream stream = new FileOutputStream("IOTest/outputTest3.xml");
			XMLWriter writer = new XMLWriter();
			writer.write(table, stream, true);
		}catch(Exception ex){
			System.out.println("can't load");
		}
		table.clearTable();
		
		try{
			InputStream stream = new FileInputStream("IOTest/outputTest3.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		assertEquals(table.balls().size(), 1);
	}
	
	public void test11(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test4.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		
		try{
			OutputStream stream = new FileOutputStream("IOTest/outputTest4.xml");
			XMLWriter writer = new XMLWriter();
			writer.write(table, stream, true);
		}catch(Exception ex){
			System.out.println("can't load");
		}
		table.clearTable();
		
		try{
			InputStream stream = new FileInputStream("IOTest/outputTest4.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		assertEquals(table.balls().size(), 0);
	}
	
	public void test12(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test5.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		
		try{
			OutputStream stream = new FileOutputStream("IOTest/outputTest5.xml");
			XMLWriter writer = new XMLWriter();
			writer.write(table, stream, true);
		}catch(Exception ex){
			System.out.println("can't load");
		}
		table.clearTable();
		
		try{
			InputStream stream = new FileInputStream("IOTest/outputTest5.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		assertEquals(table.balls().size(), 1);
	}
	
	public void test13(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test6.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		
		try{
			OutputStream stream = new FileOutputStream("IOTest/outputTest6.xml");
			XMLWriter writer = new XMLWriter();
			writer.write(table, stream, true);
		}catch(Exception ex){
			System.out.println("can't load");
		}
		table.clearTable();
		
		try{
			InputStream stream = new FileInputStream("IOTest/outputTest6.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		assertEquals(table.balls().size(), 0);
	}
	
	public void test14(){
		Table table = new Table();
		try{
			InputStream stream = new FileInputStream("IOTest/test6.txt");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		
		try{
			OutputStream stream = new FileOutputStream("IOTest/outputTest7.xml");
			XMLWriter writer = new XMLWriter();
			writer.write(table, stream, true);
		}catch(Exception ex){
			System.out.println("can't load");
		}
		table.clearTable();
		
		try{
			InputStream stream = new FileInputStream("IOTest/outputTest7.xml");
			XMLReader loader = new XMLReader(stream, table, true);
			loader.parse();
		}catch(Exception e){
			System.out.println("can't load");
		}
		assertEquals(table.balls().size(), 1);
	}
}
